<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:pain="urn:iso:std:iso:20022:tech:xsd:pain.001.001.03"
    xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2"
    xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2"
    exclude-result-prefixes="xs pain">

    <xsl:output method="xml" encoding="UTF-8" indent="yes"/>
    <xsl:strip-space elements="*"/>

    <xsl:template match="/">
        <xsl:apply-templates select="pain:Document"/>
    </xsl:template>

    <xsl:template match="pain:Document">
        <xsl:variable name="creditTransfers" select=".//pain:CdtTrfTxInf"/>
        <xsl:variable name="currencyNode" select="(.//pain:InstdAmt/@Ccy)[1]"/>
        <xsl:variable name="resolvedCurrency" select="if (string-length(normalize-space(string($currencyNode))) > 0) then string($currencyNode) else 'EUR'"/>
        <xsl:variable name="sumAmounts" as="xs:decimal" select="
            sum(for $amt in $creditTransfers/pain:Amt/pain:InstdAmt
                return if (normalize-space($amt) != '') then xs:decimal(normalize-space($amt)) else 0)"/>
        <xsl:variable name="issueDate" select="
            if (normalize-space(pain:CstmrCdtTrfInitn/pain:GrpHdr/pain:CreDtTm) != '')
                then substring(normalize-space(pain:CstmrCdtTrfInitn/pain:GrpHdr/pain:CreDtTm), 1, 10)
            else normalize-space(pain:CstmrCdtTrfInitn/pain:PmtInf[1]/pain:ReqdExctnDt)"/>
        <xsl:variable name="dueDate" select="
            if (normalize-space(pain:CstmrCdtTrfInitn/pain:PmtInf[1]/pain:ReqdExctnDt) != '')
                then normalize-space(pain:CstmrCdtTrfInitn/pain:PmtInf[1]/pain:ReqdExctnDt)
            else $issueDate"/>

        <Invoice xmlns="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2"
                 xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2"
                 xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2">
            <cbc:CustomizationID>urn:cen.eu:en16931:2017</cbc:CustomizationID>
            <cbc:ProfileID>urn:iso:std:iso:20022:tech:xsd:pain.001.001.03</cbc:ProfileID>
            <cbc:ID>
                <xsl:value-of select="normalize-space(pain:CstmrCdtTrfInitn/pain:GrpHdr/pain:MsgId)"/>
            </cbc:ID>
            <cbc:IssueDate>
                <xsl:value-of select="$issueDate"/>
            </cbc:IssueDate>
            <cbc:DueDate>
                <xsl:value-of select="$dueDate"/>
            </cbc:DueDate>
            <cbc:InvoiceTypeCode>380</cbc:InvoiceTypeCode>
            <cbc:DocumentCurrencyCode>
                <xsl:value-of select="$resolvedCurrency"/>
            </cbc:DocumentCurrencyCode>

            <cac:AccountingSupplierParty>
                <cac:Party>
                    <cac:PartyName>
                        <cbc:Name>
                            <xsl:value-of select="normalize-space(pain:CstmrCdtTrfInitn/pain:PmtInf[1]/pain:Dbtr/pain:Nm)"/>
                        </cbc:Name>
                    </cac:PartyName>
                    <cac:PartyIdentification>
                        <cbc:ID>
                            <xsl:value-of select="normalize-space(pain:CstmrCdtTrfInitn/pain:PmtInf[1]/pain:DbtrAcct/pain:Id/pain:IBAN)"/>
                        </cbc:ID>
                    </cac:PartyIdentification>
                </cac:Party>
            </cac:AccountingSupplierParty>

            <cac:AccountingCustomerParty>
                <cac:Party>
                    <cac:PartyName>
                        <cbc:Name>
                            <xsl:value-of select="normalize-space($creditTransfers[1]/pain:Cdtr/pain:Nm)"/>
                        </cbc:Name>
                    </cac:PartyName>
                    <cac:PartyIdentification>
                        <cbc:ID>
                            <xsl:value-of select="normalize-space($creditTransfers[1]/pain:CdtrAcct/pain:Id/pain:IBAN)"/>
                        </cbc:ID>
                    </cac:PartyIdentification>
                </cac:Party>
            </cac:AccountingCustomerParty>

            <cac:PaymentMeans>
                <cbc:PaymentMeansCode>
                    <xsl:value-of select="normalize-space(pain:CstmrCdtTrfInitn/pain:PmtInf[1]/pain:PmtMtd)"/>
                </cbc:PaymentMeansCode>
                <cbc:PaymentID>
                    <xsl:value-of select="normalize-space(pain:CstmrCdtTrfInitn/pain:PmtInf[1]/pain:PmtInfId)"/>
                </cbc:PaymentID>
                <cac:PayeeFinancialAccount>
                    <cbc:ID>
                        <xsl:value-of select="normalize-space($creditTransfers[1]/pain:CdtrAcct/pain:Id/pain:IBAN)"/>
                    </cbc:ID>
                    <cac:FinancialInstitutionBranch>
                        <cbc:Name>
                            <xsl:value-of select="normalize-space($creditTransfers[1]/pain:CdtrAgt/pain:FinInstnId/pain:BIC)"/>
                        </cbc:Name>
                    </cac:FinancialInstitutionBranch>
                </cac:PayeeFinancialAccount>
            </cac:PaymentMeans>

            <cac:PaymentTerms>
                <cbc:Note>
                    <xsl:value-of select="normalize-space(string-join($creditTransfers/pain:RmtInf/pain:Ustrd, ' '))"/>
                </cbc:Note>
            </cac:PaymentTerms>

            <cac:TaxTotal>
                <cbc:TaxAmount currencyID="{$resolvedCurrency}">0.00</cbc:TaxAmount>
                <cac:TaxSubtotal>
                    <cbc:TaxableAmount currencyID="{$resolvedCurrency}">
                        <xsl:value-of select="format-number($sumAmounts, '0.00')"/>
                    </cbc:TaxableAmount>
                    <cbc:TaxAmount currencyID="{$resolvedCurrency}">0.00</cbc:TaxAmount>
                    <cac:TaxCategory>
                        <cbc:ID>Z</cbc:ID>
                        <cbc:Percent>0</cbc:Percent>
                        <cac:TaxScheme>
                            <cbc:ID>VAT</cbc:ID>
                        </cac:TaxScheme>
                    </cac:TaxCategory>
                </cac:TaxSubtotal>
            </cac:TaxTotal>

            <cac:LegalMonetaryTotal>
                <cbc:LineExtensionAmount currencyID="{$resolvedCurrency}">
                    <xsl:value-of select="format-number($sumAmounts, '0.00')"/>
                </cbc:LineExtensionAmount>
                <cbc:TaxExclusiveAmount currencyID="{$resolvedCurrency}">
                    <xsl:value-of select="format-number($sumAmounts, '0.00')"/>
                </cbc:TaxExclusiveAmount>
                <cbc:TaxInclusiveAmount currencyID="{$resolvedCurrency}">
                    <xsl:value-of select="format-number($sumAmounts, '0.00')"/>
                </cbc:TaxInclusiveAmount>
                <cbc:PayableAmount currencyID="{$resolvedCurrency}">
                    <xsl:value-of select="format-number($sumAmounts, '0.00')"/>
                </cbc:PayableAmount>
            </cac:LegalMonetaryTotal>

            <xsl:for-each select="$creditTransfers">
                <xsl:variable name="lineAmount" as="xs:decimal" select="
                    if (normalize-space(pain:Amt/pain:InstdAmt) != '')
                        then xs:decimal(normalize-space(pain:Amt/pain:InstdAmt))
                    else 0"/>
                <cac:InvoiceLine>
                    <cbc:ID>
                        <xsl:value-of select="position()"/>
                    </cbc:ID>
                    <cbc:InvoicedQuantity unitCode="EA">1</cbc:InvoicedQuantity>
                    <cbc:LineExtensionAmount currencyID="{$resolvedCurrency}">
                        <xsl:value-of select="format-number($lineAmount, '0.00')"/>
                    </cbc:LineExtensionAmount>
                    <cac:Item>
                        <cbc:Description>
                            <xsl:value-of select="normalize-space(pain:RmtInf/pain:Ustrd)"/>
                        </cbc:Description>
                        <cbc:Name>
                            <xsl:value-of select="normalize-space(pain:Cdtr/pain:Nm)"/>
                        </cbc:Name>
                        <cac:ClassifiedTaxCategory>
                            <cbc:ID>Z</cbc:ID>
                            <cbc:Percent>0</cbc:Percent>
                            <cac:TaxScheme>
                                <cbc:ID>VAT</cbc:ID>
                            </cac:TaxScheme>
                        </cac:ClassifiedTaxCategory>
                    </cac:Item>
                    <cac:Price>
                        <cbc:PriceAmount currencyID="{$resolvedCurrency}">
                            <xsl:value-of select="format-number($lineAmount, '0.00')"/>
                        </cbc:PriceAmount>
                    </cac:Price>
                </cac:InvoiceLine>
            </xsl:for-each>
        </Invoice>
    </xsl:template>

</xsl:stylesheet>
