/*
 * Decompiled with CFR 0.152.
 */
package ee.lnsolutions.tengine.controller;

import ee.lnsolutions.tengine.controller.TransformController;
import ee.lnsolutions.tengine.service.XRechnungTransformService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/transform"})
public class TransformController {
    private static final Logger logger = LoggerFactory.getLogger(TransformController.class);
    @Value(value="${core.aio.transform.url}")
    private String coreAioTransformUrl;
    @Value(value="${license.validation.url:}")
    private String licenseValidationUrl;
    private final RestTemplate restTemplate = new RestTemplate();
    @Autowired
    private XRechnungTransformService transformService;

    @PostMapping(value={""}, consumes={"multipart/form-data"})
    public ResponseEntity<?> transform(@RequestBody MultipartFile file, @RequestParam String targetExtension, @RequestParam String sourceEncoding, @RequestParam String sourceMimetype, @RequestParam String sourceExtension, @RequestParam String targetMimetype) {
        try {
            ResponseEntity licenseError = this.validateLicense();
            if (licenseError != null) {
                return licenseError;
            }
            logger.info("Received generic transform request: {} -> {} (targetExtension: {}, sourceMimetype: {})", new Object[]{sourceMimetype, targetMimetype, targetExtension, sourceMimetype});
            if (!"text/xml".equals(sourceMimetype) && !"application/xml".equals(sourceMimetype)) {
                logger.warn("Unsupported source MIME type: {}", (Object)sourceMimetype);
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.TEXT_PLAIN).body((Object)("Unsupported source MIME type: " + sourceMimetype));
            }
            byte[] xmlBytes = file.getBytes();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlBytes);
            boolean isXRechnung = this.transformService.isXRechnungXml((InputStream)new ByteArrayInputStream(xmlBytes));
            if (!isXRechnung) {
                logger.info("Source XML is not recognized as XRechnung, delegating to generic transform-core-aio");
                return this.delegateToCoreAio(xmlBytes, file.getOriginalFilename(), targetExtension, sourceEncoding, sourceMimetype, sourceExtension, targetMimetype);
            }
            if ("pdf".equals(targetExtension) || "application/pdf".equals(targetMimetype)) {
                logger.info("Routing to XRechnung PDF transformation");
                return this.transformXRechnungToPdf(file);
            }
            if ("html".equals(targetExtension) || "text/html".equals(targetMimetype)) {
                logger.info("Routing to XRechnung HTML transformation");
                return this.transformXRechnung(file);
            }
            logger.warn("Unsupported target format: {} / {}", (Object)targetExtension, (Object)targetMimetype);
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.TEXT_PLAIN).body((Object)("Unsupported target format: " + targetExtension));
        }
        catch (Exception e) {
            logger.error("Generic transformation failed", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.TEXT_PLAIN).body((Object)("Transformation failed: " + e.getMessage()));
        }
    }

    private ResponseEntity<byte[]> delegateToCoreAio(byte[] xmlBytes, String originalFilename, String targetExtension, String sourceEncoding, String sourceMimetype, String sourceExtension, String targetMimetype) {
        try {
            byte[] cleanedXmlBytes = this.removeUtf8Bom(xmlBytes);
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            1 fileResource = new /* Unavailable Anonymous Inner Class!! */;
            HttpHeaders fileHeaders = new HttpHeaders();
            fileHeaders.setContentType(MediaType.parseMediaType((String)(sourceMimetype + ";charset=UTF-8")));
            HttpEntity fileEntity = new HttpEntity((Object)fileResource, (MultiValueMap)fileHeaders);
            body.add((Object)"file", (Object)fileEntity);
            body.add((Object)"targetExtension", (Object)targetExtension);
            body.add((Object)"sourceEncoding", (Object)"UTF-8");
            body.add((Object)"sourceMimetype", (Object)sourceMimetype);
            body.add((Object)"sourceExtension", (Object)sourceExtension);
            body.add((Object)"targetMimetype", (Object)targetMimetype);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            logger.info("Calling core-aio at {} for generic transform {} -> {}", new Object[]{this.coreAioTransformUrl, sourceMimetype, targetMimetype});
            ResponseEntity response = this.restTemplate.postForEntity(this.coreAioTransformUrl, (Object)requestEntity, byte[].class, new Object[0]);
            logger.info("core-aio responded with status {} and body size {} bytes", (Object)response.getStatusCode(), (Object)(response.getBody() != null ? ((byte[])response.getBody()).length : 0));
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.putAll((Map)response.getHeaders());
            if (!responseHeaders.containsKey((Object)"Content-Type") && targetMimetype != null) {
                responseHeaders.setContentType(MediaType.parseMediaType((String)targetMimetype));
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)response.getStatusCode()).headers(responseHeaders)).body((Object)((byte[])response.getBody()));
        }
        catch (Exception e) {
            logger.error("Delegation to core-aio failed", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.TEXT_PLAIN).body((Object)("Fallback transformation via core-aio failed: " + e.getMessage()).getBytes());
        }
    }

    private byte[] removeUtf8Bom(byte[] bytes) {
        try {
            String content = new String(bytes, StandardCharsets.UTF_8);
            if (content.contains("\ufeff")) {
                logger.debug("Removing UTF-8 BOM from XML content before delegating to core-aio");
                String cleaned = content.replace("\ufeff", "");
                return cleaned.getBytes(StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            logger.warn("Error checking for BOM, proceeding with original bytes", (Throwable)e);
        }
        return bytes;
    }

    @PostMapping(value={"/lnsolutions-xrechnung-html"}, consumes={"multipart/form-data"}, produces={"text/html"})
    public ResponseEntity<String> transformXRechnung(@RequestBody MultipartFile file) {
        try {
            ResponseEntity licenseError = this.validateLicense();
            if (licenseError != null) {
                return licenseError;
            }
            logger.info("Received transformation request for file: {}", (Object)file.getOriginalFilename());
            logger.debug("File size: {} bytes, content type: {}", (Object)file.getSize(), (Object)file.getContentType());
            InputStream inputStream = file.getInputStream();
            logger.debug("Input stream opened successfully");
            String htmlOutput = this.transformService.transformToHtml(inputStream);
            logger.debug("Transformation service returned HTML output of length: {}", (Object)htmlOutput.length());
            logger.info("Transformation completed successfully");
            return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"text/html;charset=UTF-8")).body((Object)htmlOutput);
        }
        catch (Exception e) {
            logger.error("Transformation failed", (Throwable)e);
            logger.debug("Exception details: {}", (Object)e.getMessage(), (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.TEXT_PLAIN).body((Object)("Transformation failed: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/xrechnung/raw"}, consumes={"application/xml"}, produces={"text/html"})
    public ResponseEntity<String> transformXRechnungRaw(@RequestBody byte[] xmlContent) {
        try {
            ResponseEntity licenseError = this.validateLicense();
            if (licenseError != null) {
                return licenseError;
            }
            logger.info("Received raw transformation request, size: {} bytes", (Object)xmlContent.length);
            boolean isXRechnung = this.transformService.isXRechnungXml((InputStream)new ByteArrayInputStream(xmlContent));
            if (!isXRechnung) {
                logger.warn("Uploaded XML is not a supported XRechnung format");
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.TEXT_PLAIN).body((Object)"Uploaded XML is not a supported XRechnung format (UBL Invoice/CreditNote, CII Invoice, or ISO20022 pain.001)");
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlContent);
            String htmlOutput = this.transformService.transformToHtml((InputStream)inputStream);
            logger.info("Transformation completed successfully");
            return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"text/html;charset=UTF-8")).body((Object)htmlOutput);
        }
        catch (Exception e) {
            logger.error("Transformation failed", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.TEXT_PLAIN).body((Object)("Transformation failed: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/lnsolutions-xrechnung-pdf"}, consumes={"multipart/form-data"}, produces={"application/pdf"})
    public ResponseEntity<byte[]> transformXRechnungToPdf(@RequestBody MultipartFile file) {
        try {
            ResponseEntity licenseError = this.validateLicense();
            if (licenseError != null) {
                String body = licenseError.getBody() != null ? (String)licenseError.getBody() : "License validation failed";
                return ResponseEntity.status((HttpStatus)licenseError.getStatusCode()).contentType(MediaType.TEXT_PLAIN).body((Object)body.getBytes(StandardCharsets.UTF_8));
            }
            logger.info("Received PDF transformation request for file: {}", (Object)file.getOriginalFilename());
            logger.debug("File size: {} bytes, content type: {}", (Object)file.getSize(), (Object)file.getContentType());
            String xmlContent = new String(file.getBytes(), StandardCharsets.UTF_8);
            String htmlContent = this.transformService.transformToHtml((InputStream)new ByteArrayInputStream(xmlContent.getBytes(StandardCharsets.UTF_8)));
            logger.debug("HTML transformation completed, HTML length: {}", (Object)htmlContent.length());
            byte[] pdfOutput = this.transformService.convertHtmlToPdf(htmlContent);
            logger.debug("PDF conversion completed, PDF size: {}", (Object)pdfOutput.length);
            logger.info("PDF transformation completed successfully");
            return ResponseEntity.ok().contentType(MediaType.APPLICATION_PDF).body((Object)pdfOutput);
        }
        catch (Exception e) {
            logger.error("PDF transformation failed", (Throwable)e);
            logger.debug("Exception details: {}", (Object)e.getMessage(), (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.TEXT_PLAIN).body((Object)("PDF transformation failed: " + e.getMessage()).getBytes());
        }
    }

    private ResponseEntity<String> validateLicense() {
        if (this.licenseValidationUrl == null || this.licenseValidationUrl.trim().isEmpty()) {
            logger.warn("license.validation.url is not configured - allowing transformations without license check");
            return null;
        }
        try {
            logger.debug("Calling license validation endpoint at {}", (Object)this.licenseValidationUrl);
            ResponseEntity response = this.restTemplate.getForEntity(this.licenseValidationUrl, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                return null;
            }
            logger.warn("License validation endpoint returned status {} - blocking transformation", (Object)response.getStatusCode());
            HttpStatus status = response.getStatusCode();
            Object body = (String)response.getBody();
            if (body == null || ((String)body).isEmpty()) {
                body = "License validation failed with status: " + status.value();
            }
            MediaType contentType = MediaType.APPLICATION_JSON;
            try {
                MediaType headerType = response.getHeaders().getContentType();
                if (headerType != null) {
                    contentType = headerType;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ResponseEntity.status((HttpStatus)status).contentType(contentType).body(body);
        }
        catch (Exception e) {
            logger.error("License validation call failed", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.TEXT_PLAIN).body((Object)("License validation failed: " + e.getMessage()));
        }
    }
}

