/*
 * Decompiled with CFR 0.152.
 */
package ee.lnsolutions.tengine.controller;

import io.github.cdimascio.dotenv.Dotenv;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ConfigController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigController.class);
    private static final String DEFAULT_CONFIG_LOCATION = "classpath:transformers/xrechnung-transform-config.json";
    private static final String CONFIG_ENV_VAR = "XRECHNUNG_TRANSFORM_CONFIG";
    private final String transformerConfig;

    public ConfigController(ResourceLoader resourceLoader) {
        this.transformerConfig = this.loadTransformerConfig(resourceLoader);
    }

    @GetMapping(value={"/transform/config"}, produces={"application/json"})
    public String getConfig() {
        return this.transformerConfig;
    }

    @GetMapping(value={"/version"}, produces={"application/json"})
    public Map<String, Object> getVersion() {
        HashMap<String, Object> version = new HashMap<String, Object>();
        version.put("version", "1.0.0");
        version.put("edition", "xrechnung-tengine");
        return version;
    }

    @GetMapping(value={"/ready"}, produces={"application/json"})
    public Map<String, String> readiness() {
        HashMap<String, String> status = new HashMap<String, String>();
        status.put("status", "UP");
        return status;
    }

    private String loadTransformerConfig(ResourceLoader resourceLoader) {
        String string;
        block11: {
            String overridePath = this.resolveConfigPath();
            if (StringUtils.hasText((String)overridePath)) {
                Path path = Path.of(overridePath, new String[0]).toAbsolutePath().normalize();
                try {
                    LOGGER.info("Loading transformer configuration from {}", (Object)path);
                    return Files.readString(path);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to read transformer config from " + path, e);
                }
            }
            Resource resource = resourceLoader.getResource(DEFAULT_CONFIG_LOCATION);
            InputStream inputStream = resource.getInputStream();
            try {
                LOGGER.info("Loading transformer configuration from classpath resource: {}", (Object)DEFAULT_CONFIG_LOCATION);
                string = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to read default transformer config from classpath:transformers/xrechnung-transform-config.json", e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    private String resolveConfigPath() {
        String envValue = System.getenv(CONFIG_ENV_VAR);
        if (StringUtils.hasText((String)envValue)) {
            return envValue;
        }
        Dotenv dotenvLocal = Dotenv.configure().filename(".env.local").ignoreIfMalformed().ignoreIfMissing().load();
        envValue = dotenvLocal.get(CONFIG_ENV_VAR);
        if (StringUtils.hasText((String)envValue)) {
            return envValue;
        }
        Dotenv dotenv = Dotenv.configure().ignoreIfMalformed().ignoreIfMissing().load();
        return dotenv.get(CONFIG_ENV_VAR);
    }
}

