/*
 * Decompiled with CFR 0.152.
 */
package ee.lnsolutions.service;

import ee.lnsolutions.qname.QNames;
import java.io.IOException;
import java.io.InputStream;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class XRechnungGenerationService {
    private static Log logger = LogFactory.getLog(XRechnungGenerationService.class);
    private ServiceRegistry serviceRegistry;
    private String tengineUrl;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        logger.debug((Object)"Setting serviceRegistry");
        this.serviceRegistry = serviceRegistry;
    }

    public void setTengineUrl(String tengineUrl) {
        logger.info((Object)("Setting tengineUrl to: '" + tengineUrl + "' (length: " + tengineUrl.length() + ")"));
        if (this.tengineUrl == null || !this.tengineUrl.contains("/transform/xrechnung")) {
            this.tengineUrl = tengineUrl;
            logger.info((Object)("tengineUrl field set to: '" + this.tengineUrl + "'"));
        } else {
            logger.info((Object)("tengineUrl already has correct path, keeping: '" + this.tengineUrl + "'"));
        }
    }

    public String generateXRechnungHtml(NodeRef document) {
        logger.info((Object)("XRechnungGenerationService :: generateXRechnungHtml :: " + document));
        if (!this.isXRechnung(document)) {
            logger.info((Object)("Document is not an XRechnung document, returning xml content: " + document));
            throw new RuntimeException("Document is not an XRechnung document: " + document.getId());
        }
        try {
            ContentReader reader = this.serviceRegistry.getContentService().getReader(document, ContentModel.PROP_CONTENT);
            if (reader == null) {
                throw new RuntimeException("No content reader available for document: " + document);
            }
            logger.info((Object)("Calling T-Engine service at: " + this.tengineUrl));
            logger.debug((Object)("T-Engine URL details - configured: " + this.tengineUrl));
            return this.callTengineService(reader.getContentInputStream(), reader.getMimetype());
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create XRechnung HTML rendition", (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private String callTengineService(InputStream contentStream, String mimeType) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            Object fullUrl = this.tengineUrl;
            if (!((String)fullUrl).endsWith("/transform/lnsolutions-xrechnung-html")) {
                fullUrl = ((String)fullUrl).endsWith("/") ? (String)fullUrl + "transform/lnsolutions-xrechnung-html" : (String)fullUrl + "/transform/lnsolutions-xrechnung-html";
            }
            logger.info((Object)("Making HTTP POST to: " + (String)fullUrl));
            HttpPost httpPost = new HttpPost((String)fullUrl);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody("file", contentStream, ContentType.create((String)mimeType), "xrechnung.xml");
            HttpEntity multipart = builder.build();
            httpPost.setEntity(multipart);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                int statusCode = response.getStatusLine().getStatusCode();
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                if (statusCode >= 200 && statusCode < 300) {
                    logger.info((Object)"T-Engine transformation successful");
                    String string = responseBody;
                    return string;
                }
                logger.error((Object)("T-Engine transformation failed with status: " + statusCode + ", response: " + responseBody));
                throw new RuntimeException("T-Engine transformation failed: " + responseBody);
            }
        }
    }

    public boolean isXRechnung(NodeRef nodeRef) {
        if (this.serviceRegistry.getNodeService().exists(nodeRef)) {
            return this.serviceRegistry.getNodeService().hasAspect(nodeRef, QNames.ASPECT_XRECHNUNG_METADATA);
        }
        return false;
    }
}

