/*
 * Decompiled with CFR 0.152.
 */
package ee.lnsolutions.behavior;

import ee.lnsolutions.qname.QNames;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class XRechnungDetectionBehavior
implements NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy {
    private static final Log logger = LogFactory.getLog(XRechnungDetectionBehavior.class);
    private PolicyComponent policyComponent;
    private ServiceRegistry serviceRegistry;
    private boolean folderBasedFilteringEnabled = false;
    private String[] allowedPaths = new String[0];
    private boolean contentBasedDetectionEnabled = true;
    private boolean metadataBasedDetectionEnabled = true;
    private List<String> xrechnungMimeTypes = Arrays.asList("text/xml", "application/xml");
    private List<String> xrechnungNamespaceIndicators = Arrays.asList("urn:cen.eu:en16931", "urn:un:unece:uncefact", "urn:ferd", "urn:iso:std:iso:20022");

    public void setPolicyComponent(PolicyComponent policyComponent) {
        logger.warn((Object)("XRechnungDetectionBehavior.setPolicyComponent called with " + (policyComponent != null ? policyComponent.getClass().getName() : "null")));
        this.policyComponent = policyComponent;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        logger.warn((Object)("XRechnungDetectionBehavior.setServiceRegistry called with " + (serviceRegistry != null ? serviceRegistry.getClass().getName() : "null")));
        this.serviceRegistry = serviceRegistry;
    }

    public void setContentBasedDetectionEnabled(boolean contentBasedDetectionEnabled) {
        this.contentBasedDetectionEnabled = contentBasedDetectionEnabled;
    }

    public void setMetadataBasedDetectionEnabled(boolean metadataBasedDetectionEnabled) {
        this.metadataBasedDetectionEnabled = metadataBasedDetectionEnabled;
    }

    public void setXrechnungMimeTypes(String[] xrechnungMimeTypes) {
        this.xrechnungMimeTypes = Arrays.asList(xrechnungMimeTypes);
    }

    public void setXrechnungNamespaceIndicators(List<String> xrechnungNamespaceIndicators) {
        this.xrechnungNamespaceIndicators = xrechnungNamespaceIndicators;
    }

    public void setFolderBasedFilteringEnabled(boolean folderBasedFilteringEnabled) {
        this.folderBasedFilteringEnabled = folderBasedFilteringEnabled;
    }

    public void setAllowedPaths(String[] allowedPaths) {
        this.allowedPaths = allowedPaths;
    }

    public void registerBehaviors() {
        logger.debug((Object)"========================================");
        logger.debug((Object)"registerBehaviors() METHOD CALLED");
        logger.debug((Object)"========================================");
        if (this.policyComponent == null) {
            logger.error((Object)"PolicyComponent is null. Cannot register XRechnung detection behaviors.");
            return;
        }
        logger.debug((Object)("Registering XRechnung detection behaviors for all content nodes using policyComponent=" + (this.policyComponent != null ? this.policyComponent.getClass().getName() : "null")));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour((Object)this, "onCreateNode", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour((Object)this, "onUpdateProperties", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        logger.debug((Object)"XRechnung detection behaviors registered successfully");
        logger.debug((Object)"========================================");
    }

    public void onCreateNode(ChildAssociationRef childAssocRef) {
        logger.info((Object)"XRechnungDetectionBehavior.onCreateNode called");
        if (childAssocRef == null || childAssocRef.getChildRef() == null) {
            logger.info((Object)"childAssocRef or childRef is null, skipping");
            return;
        }
        NodeRef nodeRef = childAssocRef.getChildRef();
        logger.info((Object)("Processing node: " + nodeRef));
        if (!this.serviceRegistry.getNodeService().exists(nodeRef)) {
            logger.info((Object)("Node does not exist: " + nodeRef));
            return;
        }
        if (this.serviceRegistry.getNodeService().hasAspect(nodeRef, QNames.ASPECT_XRECHNUNG_METADATA)) {
            logger.info((Object)("Node already has XRechnung aspect: " + nodeRef));
            return;
        }
        logger.info((Object)("Checking if node is XRechnung document: " + nodeRef));
        boolean isXRechnung = this.isXRechnungDocument(nodeRef);
        logger.info((Object)("isXRechnungDocument result: " + isXRechnung));
        if (isXRechnung) {
            logger.info((Object)("Applying XRechnung aspect to node: " + nodeRef));
            this.applyXRechnungAspect(nodeRef);
        } else {
            logger.info((Object)("Node is not an XRechnung document, skipping: " + nodeRef));
        }
    }

    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (nodeRef == null || !this.serviceRegistry.getNodeService().exists(nodeRef)) {
            return;
        }
        if (this.serviceRegistry.getNodeService().hasAspect(nodeRef, QNames.ASPECT_XRECHNUNG_METADATA)) {
            logger.debug((Object)("Node already has XRechnung aspect: " + nodeRef));
            return;
        }
        if (before.get(ContentModel.PROP_CONTENT) == null && after.get(ContentModel.PROP_CONTENT) != null && this.isXRechnungDocument(nodeRef)) {
            this.applyXRechnungAspect(nodeRef);
        }
    }

    private boolean isInAllowedPath(NodeRef nodeRef) {
        if (!this.folderBasedFilteringEnabled || this.allowedPaths.length == 0) {
            return true;
        }
        try {
            String nodePath = this.serviceRegistry.getNodeService().getPath(nodeRef).toDisplayPath(this.serviceRegistry.getNodeService(), this.serviceRegistry.getPermissionService());
            for (String allowedPath : this.allowedPaths) {
                if (!nodePath.contains(allowedPath) && !nodePath.matches(allowedPath)) continue;
                return true;
            }
            logger.debug((Object)("Document path '" + nodePath + "' not in allowed paths for XRechnung detection"));
            return false;
        }
        catch (Exception e) {
            logger.warn((Object)("Error checking document path for folder filtering: " + e.getMessage()));
            return false;
        }
    }

    private boolean isXRechnungDocument(NodeRef nodeRef) {
        if (!this.isInAllowedPath(nodeRef)) {
            return false;
        }
        try {
            if (this.metadataBasedDetectionEnabled && this.isXRechnungByMetadata(nodeRef)) {
                logger.debug((Object)("XRechnung detected by metadata: " + nodeRef));
                return true;
            }
            if (this.contentBasedDetectionEnabled && this.isXRechnungByContent(nodeRef)) {
                logger.debug((Object)("XRechnung detected by content: " + nodeRef));
                return true;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Error detecting XRechnung for node " + nodeRef + ": " + e.getMessage()), (Throwable)e);
        }
        return false;
    }

    private Document parseXmlContent(String content) {
        try {
            String sanitized = this.sanitizeXmlContent(content);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(sanitized)));
        }
        catch (Exception e) {
            logger.error((Object)("XML validation failed: " + e.getMessage()));
            return null;
        }
    }

    private String sanitizeXmlContent(String xmlContent) {
        int firstBracket;
        if (xmlContent == null) {
            return null;
        }
        String sanitized = xmlContent;
        if (sanitized.startsWith("\ufeff")) {
            sanitized = sanitized.substring(1);
        }
        if ((firstBracket = (sanitized = sanitized.trim()).indexOf(60)) > 0) {
            sanitized = sanitized.substring(firstBracket);
        }
        return sanitized;
    }

    private boolean isXRechnungByMetadata(NodeRef nodeRef) {
        try {
            Boolean isDigitalInvoice = (Boolean)this.serviceRegistry.getNodeService().getProperty(nodeRef, QNames.PROP_IS_DIGITAL_INVOICE);
            return Boolean.TRUE.equals(isDigitalInvoice);
        }
        catch (Exception e) {
            logger.debug((Object)("Error checking metadata for XRechnung detection: " + e.getMessage()));
            return false;
        }
    }

    private boolean isXRechnungByContent(NodeRef nodeRef) {
        try {
            ContentReader reader = this.serviceRegistry.getContentService().getReader(nodeRef, ContentModel.PROP_CONTENT);
            if (reader == null) {
                return false;
            }
            String mimeType = reader.getMimetype();
            if (mimeType == null || !this.isSupportedMimeType(mimeType)) {
                return false;
            }
            String content = IOUtils.toString((InputStream)reader.getContentInputStream(), (String)"UTF-8");
            return this.isXRechnungXmlContent(content);
        }
        catch (Exception e) {
            logger.debug((Object)("Error checking content for XRechnung detection: " + e.getMessage()));
            return false;
        }
    }

    private boolean isSupportedMimeType(String mimeType) {
        for (String supportedType : this.xrechnungMimeTypes) {
            if (!supportedType.equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    private boolean isXRechnungXmlContent(String content) {
        String[] xrechnungIndicators;
        Element root;
        if (content == null || content.isEmpty()) {
            return false;
        }
        String lowerContent = content.toLowerCase();
        Document document = this.parseXmlContent(content);
        if (document != null && (root = document.getDocumentElement()) != null) {
            String localLower;
            String namespace = root.getNamespaceURI();
            String localName = root.getLocalName();
            if (namespace != null) {
                String namespaceLower = namespace.toLowerCase();
                for (String indicator : this.xrechnungNamespaceIndicators) {
                    if (!namespaceLower.contains(indicator.toLowerCase())) continue;
                    return true;
                }
            }
            if (localName != null && ((localLower = localName.toLowerCase()).contains("invoice") || localLower.contains("document"))) {
                for (String indicator : this.xrechnungNamespaceIndicators) {
                    if (!localLower.contains(indicator.toLowerCase())) continue;
                    return true;
                }
            }
        }
        for (String indicator : xrechnungIndicators = new String[]{"xrechnung", "ubl:invoice", "cii:crossindustryinvoice", "ram:exchangeddocument", "rsm:crossindustryinvoice"}) {
            if (!lowerContent.contains(indicator)) continue;
            return true;
        }
        return false;
    }

    private void applyXRechnungAspect(NodeRef nodeRef) {
        try {
            this.serviceRegistry.getNodeService().addAspect(nodeRef, QNames.ASPECT_XRECHNUNG_METADATA, null);
            this.serviceRegistry.getNodeService().setProperty(nodeRef, QNames.PROP_IS_DIGITAL_INVOICE, (Serializable)Boolean.valueOf(true));
            String profile = this.extractDigitalInvoiceProfile(nodeRef);
            if (profile != null) {
                this.serviceRegistry.getNodeService().setProperty(nodeRef, QNames.PROP_DIGITAL_INVOICE_PROFILE, (Serializable)((Object)profile));
                String profileDescShort = this.extractDigitalInvoiceProfileShort(profile);
                if (profileDescShort != null) {
                    this.serviceRegistry.getNodeService().setProperty(nodeRef, QNames.PROP_DIGITAL_INVOICE_PROFILE_DESC_SHORT, (Serializable)((Object)profileDescShort));
                } else {
                    this.serviceRegistry.getNodeService().setProperty(nodeRef, QNames.PROP_DIGITAL_INVOICE_PROFILE_DESC_SHORT, (Serializable)((Object)"X"));
                }
            } else {
                this.serviceRegistry.getNodeService().setProperty(nodeRef, QNames.PROP_DIGITAL_INVOICE_PROFILE_DESC_SHORT, (Serializable)((Object)"X"));
            }
            logger.info((Object)("Applied XRechnung aspect to document: " + nodeRef));
        }
        catch (Exception e) {
            logger.error((Object)("Failed to apply XRechnung aspect to document " + nodeRef + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private String extractDigitalInvoiceProfile(NodeRef nodeRef) {
        try {
            ContentReader reader = this.serviceRegistry.getContentService().getReader(nodeRef, ContentModel.PROP_CONTENT);
            if (reader == null) {
                return null;
            }
            String content = IOUtils.toString((InputStream)reader.getContentInputStream(), (String)"UTF-8");
            return this.extractDigitalInvoiceProfileFromContent(content);
        }
        catch (Exception e) {
            logger.debug((Object)("Error extracting digital invoice profile for node " + nodeRef + ": " + e.getMessage()));
            return null;
        }
    }

    private String extractDigitalInvoiceProfileFromContent(String content) {
        if (content == null || content.isEmpty()) {
            return null;
        }
        Pattern pattern = Pattern.compile("urn:[^#\\s]*(xrechnung_[0-9.]+)");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String extractDigitalInvoiceProfileShort(String profile) {
        if (profile == null || profile.isEmpty()) {
            return null;
        }
        String lower = profile.toLowerCase();
        if (lower.contains("xrechnung")) {
            return "X";
        }
        return profile;
    }
}

