/*
 * Decompiled with CFR 0.152.
 */
package ee.lnsolutions.api.node;

import ee.lnsolutions.license.LicenseExpiredException;
import ee.lnsolutions.service.XRechnungGenerationService;
import java.io.IOException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class XRechnungHtmlWebScript
extends AbstractWebScript {
    private static Log logger = LogFactory.getLog(XRechnungHtmlWebScript.class);
    private static int ERROR_CODE = 400;
    private static int LICENSE_EXPIRED_CODE = 402;
    private XRechnungGenerationService xRechnungGenerationService;

    public void setXRechnungGenerationService(XRechnungGenerationService xRechnungGenerationService) {
        this.xRechnungGenerationService = xRechnungGenerationService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        try {
            String nodeId = req.getParameter("id");
            NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
            String response = this.xRechnungGenerationService.generateXRechnungHtml(nodeRef);
            res.setContentType("text/html");
            res.getWriter().write(response);
        }
        catch (LicenseExpiredException e) {
            logger.error((Object)"License validation failed", (Throwable)e);
            JSONObject jsonResponse = new JSONObject();
            try {
                jsonResponse.put("status", LICENSE_EXPIRED_CODE);
                jsonResponse.put("message", (Object)"License expired or invalid. Please contact LN Solutions to purchase a license.");
                jsonResponse.put("errorType", (Object)"LICENSE_EXPIRED");
            }
            catch (JSONException e1) {
                logger.error((Object)e1);
            }
            res.setStatus(LICENSE_EXPIRED_CODE);
            res.setContentType("application/json");
            res.getWriter().write(jsonResponse.toString());
        }
        catch (Exception e) {
            logger.error((Object)e);
            JSONObject jsonResponse = new JSONObject();
            try {
                jsonResponse.put("status", ERROR_CODE);
                jsonResponse.put("message", (Object)e.getMessage());
            }
            catch (JSONException e1) {
                logger.error((Object)e1);
            }
            res.setStatus(ERROR_CODE);
            res.setContentType("application/json");
            res.getWriter().write(jsonResponse.toString());
        }
    }
}

