/*
 * Decompiled with CFR 0.152.
 */
package ee.lnsolutions.api.admin;

import ee.lnsolutions.license.LicenseService;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class LicenseStatusWebScript
extends AbstractWebScript {
    private static final Log logger = LogFactory.getLog(LicenseStatusWebScript.class);
    private LicenseService licenseService;

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        try {
            boolean valid = this.licenseService != null && this.licenseService.isLicenseValid();
            String status = this.licenseService != null ? this.licenseService.getLicenseStatus() : "unknown";
            int daysRemaining = this.licenseService != null ? this.licenseService.getTrialDaysRemaining() : 0;
            JSONObject jsonResponse = new JSONObject();
            jsonResponse.put("valid", valid);
            jsonResponse.put("status", (Object)status);
            jsonResponse.put("daysRemaining", daysRemaining);
            res.setStatus(valid ? 200 : 402);
            res.setContentType("application/json");
            res.getWriter().write(jsonResponse.toString());
        }
        catch (Exception e) {
            logger.error((Object)"License status check failed", (Throwable)e);
            JSONObject errorResponse = new JSONObject();
            try {
                errorResponse.put("valid", false);
                errorResponse.put("status", (Object)"error");
                errorResponse.put("message", (Object)e.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
            res.setStatus(500);
            res.setContentType("application/json");
            res.getWriter().write(errorResponse.toString());
        }
    }
}

