/*
 * Decompiled with CFR 0.152.
 */
package ee.lnsolutions.api.admin;

import ee.lnsolutions.license.LicenseService;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class LicenseActivationWebScript
extends AbstractWebScript {
    private static Log logger = LogFactory.getLog(LicenseActivationWebScript.class);
    private LicenseService licenseService;

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        try {
            JSONObject jsonResponse = new JSONObject();
            jsonResponse.put("status", (Object)"error");
            jsonResponse.put("message", (Object)"License activation via API is no longer supported. Configure the license key in alfresco-global.properties.");
            res.setContentType("application/json");
            res.getWriter().write(jsonResponse.toString());
        }
        catch (Exception e) {
            logger.error((Object)"License activation failed", (Throwable)e);
            this.sendErrorResponse(res, 500, "Internal server error: " + e.getMessage());
        }
    }

    private void sendErrorResponse(WebScriptResponse res, int statusCode, String message) throws IOException {
        JSONObject errorResponse = new JSONObject();
        try {
            errorResponse.put("status", (Object)"error");
            errorResponse.put("message", (Object)message);
        }
        catch (JSONException e) {
            logger.error((Object)"Failed to create error response", (Throwable)e);
        }
        res.setStatus(statusCode);
        res.setContentType("application/json");
        res.getWriter().write(errorResponse.toString());
    }
}

