/*
 * Decompiled with CFR 0.152.
 */
package ee.lnsolutions.license;

import ee.lnsolutions.license.LicenseQNames;
import java.net.NetworkInterface;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.crypto.Cipher;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LicenseService {
    private static final Log logger = LogFactory.getLog(LicenseService.class);
    private static final int TRIAL_DAYS_CONSTANT = 7;
    private static final String LICENSE_FOLDER_NAME = "XRechnung-License-Data";
    private static final String LICENSE_STATUS_TRIAL = "trial";
    private static final String LICENSE_STATUS_LICENSED = "licensed";
    private static final String LICENSE_STATUS_EXPIRED = "expired";
    private static final String LICENSE_STATUS_PERMANENT = "permanent";
    @Autowired
    private ServiceRegistry serviceRegistry;
    private NodeService nodeService;
    private String moduleId;
    private String publicKey;
    private String licenseKey;
    private String cachedServerFingerprint;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.nodeService = serviceRegistry.getNodeService();
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    public boolean isLicenseValid() {
        String licenseKey = this.licenseKey;
        if (licenseKey == null || licenseKey.trim().isEmpty()) {
            return false;
        }
        if (!this.validateLicenseKey(licenseKey)) {
            logger.error((Object)("Configured license key failed cryptographic validation - possible tampering for module: " + this.moduleId));
            return false;
        }
        if (this.isPermanentLicenseKey(licenseKey)) {
            return true;
        }
        return this.isTrialValid(licenseKey);
    }

    public String getLicenseStatus() {
        String licenseKey = this.licenseKey;
        if (licenseKey == null || licenseKey.trim().isEmpty()) {
            return LICENSE_STATUS_TRIAL;
        }
        if (this.isPermanentLicenseKey(licenseKey)) {
            return LICENSE_STATUS_PERMANENT;
        }
        if (this.isTrialValid(licenseKey)) {
            return LICENSE_STATUS_LICENSED;
        }
        return LICENSE_STATUS_EXPIRED;
    }

    public boolean activateLicense(String licenseKey) {
        if (this.validateLicenseKey(licenseKey)) {
            NodeRef licenseNode = this.getOrCreateLicenseNode();
            String serverFingerprint = this.generateServerFingerprint();
            HashMap<QName, String> properties = new HashMap<QName, String>();
            properties.put(LicenseQNames.PROP_LICENSE_KEY, licenseKey);
            properties.put(LicenseQNames.PROP_LICENSE_SERVER_FINGERPRINT, serverFingerprint);
            this.nodeService.setProperties(licenseNode, properties);
            logger.info((Object)("License activated for module: " + this.moduleId + " on server: " + serverFingerprint.substring(0, 8) + "..."));
            return true;
        }
        return false;
    }

    private NodeRef getLicenseNode() {
        NodeRef licenseFolder = this.getOrCreateLicenseFolder();
        List children = this.nodeService.getChildAssocs(licenseFolder);
        for (ChildAssociationRef child : children) {
            String moduleIdProp;
            NodeRef childNode = child.getChildRef();
            if (!this.nodeService.getType(childNode).equals((Object)LicenseQNames.TYPE_LICENSE_INFO) || !this.moduleId.equals(moduleIdProp = (String)((Object)this.nodeService.getProperty(childNode, LicenseQNames.PROP_LICENSE_MODULE_ID)))) continue;
            return childNode;
        }
        return null;
    }

    private NodeRef getOrCreateLicenseNode() {
        NodeRef existing = this.getLicenseNode();
        if (existing != null) {
            return existing;
        }
        NodeRef licenseFolder = this.getOrCreateLicenseFolder();
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        properties.put(ContentModel.PROP_NAME, this.moduleId + "-license");
        properties.put(LicenseQNames.PROP_LICENSE_MODULE_ID, this.moduleId);
        ChildAssociationRef childAssoc = this.nodeService.createNode(licenseFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)ContentModel.PROP_NAME.getNamespaceURI(), (String)(this.moduleId + "-license")), LicenseQNames.TYPE_LICENSE_INFO, properties);
        logger.info((Object)("Created license node for module: " + this.moduleId));
        return childAssoc.getChildRef();
    }

    private synchronized NodeRef getOrCreateLicenseFolder() {
        NodeRef dataDictionary = this.getDataDictionary();
        List children = this.nodeService.getChildAssocs(dataDictionary);
        for (ChildAssociationRef child : children) {
            String name = (String)((Object)this.nodeService.getProperty(child.getChildRef(), ContentModel.PROP_NAME));
            if (!LICENSE_FOLDER_NAME.equals(name)) continue;
            return child.getChildRef();
        }
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_NAME, LICENSE_FOLDER_NAME);
        try {
            ChildAssociationRef childAssoc = this.nodeService.createNode(dataDictionary, ContentModel.ASSOC_CONTAINS, QName.createQName((String)ContentModel.PROP_NAME.getNamespaceURI(), (String)LICENSE_FOLDER_NAME), ContentModel.TYPE_FOLDER, properties);
            return childAssoc.getChildRef();
        }
        catch (DuplicateChildNodeNameException e) {
            logger.info((Object)"License folder was created by another process, finding existing folder");
            children = this.nodeService.getChildAssocs(dataDictionary);
            for (ChildAssociationRef child : children) {
                String name = (String)((Object)this.nodeService.getProperty(child.getChildRef(), ContentModel.PROP_NAME));
                if (!LICENSE_FOLDER_NAME.equals(name)) continue;
                return child.getChildRef();
            }
            throw new RuntimeException("Could not find or create license folder", e);
        }
    }

    private NodeRef getDataDictionary() {
        try {
            NodeRef rootNode = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
            List companyHomeAssocs = this.nodeService.getChildAssocs(rootNode, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)QName.createQName((String)"{http://www.alfresco.org/model/application/1.0}company_home"));
            if (companyHomeAssocs.isEmpty()) {
                throw new RuntimeException("Company Home not found");
            }
            NodeRef companyHome = ((ChildAssociationRef)companyHomeAssocs.get(0)).getChildRef();
            List dataDictAssocs = this.nodeService.getChildAssocs(companyHome, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)QName.createQName((String)"{http://www.alfresco.org/model/application/1.0}dictionary"));
            if (dataDictAssocs.isEmpty()) {
                throw new RuntimeException("Data Dictionary not found under Company Home");
            }
            return ((ChildAssociationRef)dataDictAssocs.get(0)).getChildRef();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to locate Data Dictionary", (Throwable)e);
            throw new RuntimeException("Data Dictionary not found", e);
        }
    }

    private String generateServerFingerprint() {
        if (this.cachedServerFingerprint != null) {
            return this.cachedServerFingerprint;
        }
        this.cachedServerFingerprint = this.generateServerFingerprintInternal();
        return this.cachedServerFingerprint;
    }

    private String generateServerFingerprintInternal() {
        try {
            StringBuilder fingerprint = new StringBuilder();
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    byte[] mac;
                    NetworkInterface ni = interfaces.nextElement();
                    if (ni.isLoopback() || !ni.isUp() || (mac = ni.getHardwareAddress()) == null) continue;
                    StringBuilder macStr = new StringBuilder();
                    for (byte b : mac) {
                        macStr.append(String.format("%02x", b));
                    }
                    fingerprint.append("MAC:").append((CharSequence)macStr).append("|");
                    break;
                }
            }
            catch (Exception e) {
                fingerprint.append("MAC:unknown|");
            }
            String installPath = System.getProperty("alfresco.home", System.getProperty("user.dir", "unknown"));
            fingerprint.append("PATH:").append(installPath);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(fingerprint.toString().getBytes("UTF-8"));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                hexString.append(String.format("%02x", b));
            }
            return hexString.toString();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to generate server fingerprint", (Throwable)e);
            try {
                String hostname = System.getProperty("hostname", "fallback");
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                byte[] hash = digest.digest(hostname.getBytes("UTF-8"));
                StringBuilder hexString = new StringBuilder();
                for (byte b : hash) {
                    hexString.append(String.format("%02x", b));
                }
                return hexString.toString();
            }
            catch (Exception ex) {
                logger.error((Object)"Fallback fingerprint generation failed", (Throwable)ex);
                return "fallback-fingerprint";
            }
        }
    }

    private boolean isTrialValid(String licenseKey) {
        if (licenseKey == null) {
            return false;
        }
        Date trialDueDate = this.extractTrialDueDateFromKey(licenseKey);
        if (trialDueDate != null) {
            Instant due;
            Instant now = Instant.now();
            return !now.isAfter(due = trialDueDate.toInstant());
        }
        return false;
    }

    private boolean isPermanentLicenseKey(String licenseKey) {
        return licenseKey != null && licenseKey.contains("-PERMANENT-");
    }

    private boolean validateLicenseKey(String licenseKey) {
        if (licenseKey == null || !licenseKey.startsWith("XRECHNUNG-")) {
            return false;
        }
        if (this.publicKey == null || this.publicKey.trim().isEmpty()) {
            logger.warn((Object)("Public key not configured - cannot validate license key for module: " + this.moduleId));
            return false;
        }
        try {
            int lastDashIndex = licenseKey.lastIndexOf(45);
            if (lastDashIndex == -1) {
                return false;
            }
            String signatureBase64 = licenseKey.substring(lastDashIndex + 1);
            String licenseData = licenseKey.substring("XRECHNUNG-".length(), lastDashIndex);
            byte[] publicKeyBytes = Base64.getDecoder().decode(this.publicKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey pubKey = keyFactory.generatePublic(keySpec);
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(pubKey);
            signature.update(licenseData.getBytes());
            byte[] signatureBytes = Base64.getDecoder().decode(signatureBase64);
            return signature.verify(signatureBytes);
        }
        catch (Exception e) {
            logger.warn((Object)("License key validation failed: " + e.getMessage()));
            return false;
        }
    }

    private Date extractTrialDueDateFromKey(String licenseKey) {
        if (licenseKey == null || !licenseKey.contains("-TRIAL-")) {
            return null;
        }
        if (this.publicKey == null || this.publicKey.trim().isEmpty()) {
            logger.warn((Object)("Public key not configured - cannot decrypt trial due date for module: " + this.moduleId));
            return null;
        }
        try {
            byte[] publicKeyBytes = Base64.getDecoder().decode(this.publicKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey pubKey = keyFactory.generatePublic(keySpec);
            String keyWithoutPrefix = licenseKey.substring("XRECHNUNG-".length());
            int lastDashIndex = keyWithoutPrefix.lastIndexOf(45);
            if (lastDashIndex == -1) {
                return null;
            }
            String keyWithoutSignature = keyWithoutPrefix.substring(0, lastDashIndex);
            String[] parts = keyWithoutSignature.split("-");
            for (int i = 0; i < parts.length; ++i) {
                if (!"TRIAL".equals(parts[i]) || i + 1 >= parts.length) continue;
                String encryptedDueDate = parts[i + 1];
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(2, pubKey);
                byte[] decryptedBytes = cipher.doFinal(Base64.getDecoder().decode(encryptedDueDate));
                String decrypted = new String(decryptedBytes, "UTF-8");
                int lastDash = decrypted.lastIndexOf(45);
                String dueDateStr = lastDash >= 0 && lastDash + 1 < decrypted.length() ? decrypted.substring(lastDash + 1) : decrypted;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                return sdf.parse(dueDateStr);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to parse trial due date from license key: " + e.getMessage()));
        }
        return null;
    }

    public int getTrialDaysRemaining() {
        Date trialDueDate;
        String licenseKey = this.licenseKey;
        if (licenseKey != null && this.isPermanentLicenseKey(licenseKey)) {
            return 0;
        }
        if (licenseKey != null && (trialDueDate = this.extractTrialDueDateFromKey(licenseKey)) != null) {
            long daysUntilDue = ChronoUnit.DAYS.between(Instant.now(), trialDueDate.toInstant());
            return Math.max(0, (int)daysUntilDue + 1);
        }
        return -1;
    }
}

