/*
 * Decompiled with CFR 0.152.
 */
package ee.lnsolutions.license;

import ee.lnsolutions.license.LicenseExpiredException;
import ee.lnsolutions.license.LicenseService;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicenseInterceptor
implements MethodInterceptor {
    private static final Log logger = LogFactory.getLog(LicenseInterceptor.class);
    private LicenseService licenseService;

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.licenseService != null && !this.licenseService.isLicenseValid()) {
            String message = "License validation failed for module. Trial period may have expired or license key is invalid.";
            logger.error((Object)message);
            throw new LicenseExpiredException(message);
        }
        return invocation.proceed();
    }
}

